%------------------------------------------------------------------------------
% File     : CSR150^1 : TPTP v7.4.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : How many grandchildren does John at most have?
% Version  : Especial > Reduced > Especial.
% English  : The number of persons John is grandparent of is maximally three. 
%            How many grandchildren does John at most have?

% Refs     : [PS07]  Pease & Sutcliffe (2007), First Order Reasoning on a L
%          : [BP10]  Benzmueller & Pease (2010), Progress in Automating Hig
%          : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : paar_6.tq_SUMO_local [Ben10]

% Status   : Theorem
% Rating   : 0.08 v7.4.0, 0.11 v7.3.0, 0.10 v7.2.0, 0.12 v7.1.0, 0.14 v7.0.0, 0.12 v6.4.0, 0.14 v6.3.0, 0.17 v6.2.0, 0.00 v6.1.0, 0.50 v6.0.0, 0.17 v5.5.0, 0.20 v5.4.0, 0.25 v5.3.0, 0.50 v5.1.0, 0.75 v5.0.0, 0.50 v4.1.0
% Syntax   : Number of formulae    :   12 (   0 unit;   8 type;   0 defn)
%            Number of atoms       :   30 (   0 equality;  15 variable)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   26 (   0   ~;   0   |;   2   &;  22   @)
%                                         (   2 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   10 (  10   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   11 (   8   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   4   !;   3   ?;   2   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted Signature
thf(numbers,type,(
    num: $tType )).

thf(grandchild_THFTYPE_IiioI,type,(
    grandchild_THFTYPE_IiioI: $i > $i > $o )).

thf(grandparent_THFTYPE_IiioI,type,(
    grandparent_THFTYPE_IiioI: $i > $i > $o )).

thf(lCardinalityFn_THFTYPE_IIioIiI,type,(
    lCardinalityFn_THFTYPE_IIioIiI: ( $i > $o ) > $i )).

thf(lJohn_THFTYPE_i,type,(
    lJohn_THFTYPE_i: $i )).

thf(ltet_THFTYPE_IiioI,type,(
    ltet_THFTYPE_IiioI: $i > $i > $o )).

thf(n3_THFTYPE_i,type,(
    n3_THFTYPE_i: $i )).

thf(parent_THFTYPE_IiioI,type,(
    parent_THFTYPE_IiioI: $i > $i > $o )).

%----The translated axioms
thf(ax,axiom,(
    ! [X: $i,Y: $i] :
      ( ( grandparent_THFTYPE_IiioI @ X @ Y )
    <=> ? [Z: $i] :
          ( ( parent_THFTYPE_IiioI @ X @ Z )
          & ( parent_THFTYPE_IiioI @ Z @ Y ) ) ) )).

thf(ax_001,axiom,
    ( ltet_THFTYPE_IiioI
    @ ( lCardinalityFn_THFTYPE_IIioIiI
      @ ^ [X: $i] :
          ( grandparent_THFTYPE_IiioI @ lJohn_THFTYPE_i @ X ) )
    @ n3_THFTYPE_i )).

thf(ax_002,axiom,(
    ! [X: $i,Y: $i] :
      ( ( grandchild_THFTYPE_IiioI @ X @ Y )
    <=> ? [Z: $i] :
          ( ( parent_THFTYPE_IiioI @ Z @ X )
          & ( parent_THFTYPE_IiioI @ Y @ Z ) ) ) )).

%----The translated conjectures
thf(con,conjecture,(
    ? [Y: $i] :
      ( ltet_THFTYPE_IiioI
      @ ( lCardinalityFn_THFTYPE_IIioIiI
        @ ^ [X: $i] :
            ( grandchild_THFTYPE_IiioI @ X @ lJohn_THFTYPE_i ) )
      @ Y ) )).

%------------------------------------------------------------------------------
